OWNER(g:yandex_io)

LIBRARY()

PEERDIR(
    contrib/libs/curl
    yandex_io/libs/base
    yandex_io/libs/json_utils  # TODO: remove
    yandex_io/libs/device
    yandex_io/libs/telemetry
    yandex_io/libs/threading
    yandex_io/libs/logging
)

# Only perform checks when building actual packages to allow "invalid" dev
# builds and simplify autocheck platforms
IF (YANDEXIO_PACKAGE_BUILD) 
    IF (OS_ANDROID AND ARCADIA_CURL_DNS_RESOLVER != MULTITHREADED)
        MESSAGE(FATAL_ERROR "Android targets MUST be built with MULTITHREADED curl resolver, otherwise DNS will be broken (Android does not provide nameservers via /etc/resolv.conf)")
    ENDIF()

    IF (OS_LINUX AND ARCADIA_CURL_DNS_RESOLVER != MULTITHREADED)
        MESSAGE(FATAL_ERROR "Linux targets MUST be built with MULTITHREADED curl resolver, otherwise DNS will be broken (as c-ares does not reload /etc/resolv.conf)")
    ENDIF()
ENDIF()

SRCS(
    http_client.cpp
    i_http_client.cpp
)

END()

RECURSE(
    mock
)

RECURSE_FOR_TESTS(tests)
