#pragma once

#include <string>

namespace YandexIO {

    class IIotDiscovery {
    public:
        struct PairingInfo {
            std::string token;
            std::string cipher;
            std::string wifiSSID;
            std::string wifiPassword;
        };

        virtual ~IIotDiscovery();

        /**
         * Start async discovery process
         * Expected to be non-blocking (should only spawn a process)
         */
        virtual void start(const PairingInfo& pairingInfo) = 0;

        /**
         * Stop async discovery process
         * NOTE: must be noexcept as there is no reasonable failure mode for stop()
         */
        virtual void stop() noexcept = 0;
    };

} // namespace YandexIO
