## Сетевая реализация IPC на основе ASIO

### Модель выполнения

Внутри библиотеки код логически выполняется в трех "контекстах" (т.е
тредах/тредпулах/очередях исполнения):

1. Пользовательский (вызывающий код). К этому относятся все публичные методы
   Connector/Server. В общем случае может выполняться в любом треде.
2. Пользовательский колбек. Вызов функций, предоставленных пользователем,
   выполняется в переданном им CallbackQueue.
3. Низкоуровневый асинхронный колбек. Все функции, работающие с ASIO объектами,
   выполняются в приватном для библиотеке пуле фоновых тредов.

Применяются следующие ограничения:

* Пользовательский код никогда не выполняется в низкоуровневом контексте (защита
  от DoS в случае блокирующего кода в колбеке).
* Кодирование и декодирование protobuf сообщений выполняется в пользовательском
  контексте (владелец тяжелого объекта платит за него сам, не нагружает ASIO треды).

### Время жизни асинхронных объектов

Т.к. при выполнении в разных тредах времена жизни объекта и его асинхронных
колбеков не вложены, какой-либо механизм должен гарантировать что:

1. Асинхронный объект жив в момент вызова его колбека;
2. Асинхронный объект не умирает во время работы колбека.

Чтобы обеспечить это, все асинхронные объекты создаются через `make_shared()`, а
колбеки сохраняют `weak_ptr` на родительский объект. Из этого следует что:

* Колбек может быть "потерян", если объект умрет до его исполнения.
* Колбек может "продлить" время жизни до конца своего выполнения (после удаления
  последней "внешней" ссылки на объект. Во время "продленной" жизни внешние
  колбеки не должны вызываться.

### Высокоуровневый интерфейс

Реализует "внешние" интерфейсы IPC: `IConnector`, `IServer`, `IIpcFactory`:

* AsioServerFacade/AsioConnectorFacade

"Настоящие" реализации сервера/коннектора. Напрямую связаны с асинхронными
операциями, поэтому могут жить после удаления всех пользовательских ссылок.
Из-за этой особенности применимы только вместе с внешним `CallbackQueue` +
`Lifetime`.

* ProxyServerFacade/ProxyConnectorFacade

Прокси-реализации сервера/коннектора, дожидающиеся уничтожения реализации до
завершения деструктора и не имеющие ссылок кроме пользовательских.

* AsioIpcFactory

### Низкоуровневый интерфейс

* AsioAsyncWorker

Владелец фоновых тредов и `asio::io_context`.

* AsioAsyncObject

Интерфейс для асинхронных объектов. Хранит ссылку на воркера.

* AsioChannel

Асинхронный двунаправленный канал поверх установленного сокета.

* AsioTcpConnector

Асинхронный процесс создания сокета через подключение к серверу (с клиентской
стороны).

* AsioTcpAcceptor

Асинхронный процесс создания сокетов на стороне сервера.

### Утилиты

* AsioLogging
* LengthValueTokenizer
* ProtobufMessageParser
* Serialize
