#include "asio_async_object.h"

#include <util/system/yassert.h>

using namespace quasar::ipc::detail::asio_ipc;

AsioAsyncObject::AsioAsyncObject(std::shared_ptr<AsioAsyncWorker> worker)
    : worker_(std::move(worker))
{
    Y_VERIFY(worker_ != nullptr);
}

AsioAsyncObject::~AsioAsyncObject() = default;

void AsioAsyncObject::asyncStart() {
    if (!isStarted_.exchange(true)) {
        doAsyncStart();
    }
}

void AsioAsyncObject::asyncShutdown() {
    if (!isStopped_.exchange(true)) {
        doAsyncShutdown();
    }
}

std::ostream& quasar::ipc::detail::asio_ipc::operator<<(std::ostream& out, const AsioAsyncObject& obj) {
    obj.debugPrintDescription(out);
    return out;
}
