#pragma once

#include "asio_async_worker.h"

#include <memory>
#include <ostream>

namespace quasar::ipc::detail::asio_ipc {

    class AsioAsyncObject {
    public:
        explicit AsioAsyncObject(std::shared_ptr<AsioAsyncWorker> worker);
        virtual ~AsioAsyncObject();

        std::shared_ptr<AsioAsyncWorker> worker() {
            return worker_;
        }

        asio::io_context& ioContext() {
            return worker_->ioContext();
        }

        // Successive calls are idempotent
        void asyncStart();
        void asyncShutdown();

        bool isStarted() const {
            return isStarted_;
        }

        bool isStopped() const {
            return isStopped_;
        }

        bool isRunning() const {
            return isStarted_ && !isStopped_;
        }

        virtual void debugPrintDescription(std::ostream& out) const = 0;

    private:
        // Called at most once
        virtual void doAsyncStart() = 0;
        virtual void doAsyncShutdown() = 0;

    private:
        std::shared_ptr<AsioAsyncWorker> worker_;

        std::atomic_bool isStarted_{false};
        std::atomic_bool isStopped_{false};
    };

    std::ostream& operator<<(std::ostream& out, const AsioAsyncObject& obj);

} // namespace quasar::ipc::detail::asio_ipc
