#pragma once

#include "asio_async_object_storage.h"

#include <yandex_io/libs/base/named_callback_queue.h>

#include <deque>
#include <memory>
#include <optional>

#include <asio.hpp>

namespace quasar::ipc::detail::asio_ipc {

    class AsioAsyncObject;
    class AsioAsyncObjectStorage;
    class AsioCallbackPool;

    class AsioAsyncWorker {
    public:
        ~AsioAsyncWorker();

        asio::io_context& ioContext() {
            return ioContext_;
        }

        // from IAsyncWorker

        bool isRunning() const;

        void startBackgroundThreads();
        void stopBackgroundThreads();

        template <typename T, typename... Args>
        std::shared_ptr<T> create(Args&&... args) {
            return asioAsyncObjectStorage_->registerObject(std::make_unique<T>(std::forward<Args>(args)...));
        }

        template <typename T, typename... Args>
        std::shared_ptr<T> createWithDeathFuture(std::future<void>& deathFuture, Args&&... args) {
            return asioAsyncObjectStorage_->registerObject(std::make_unique<T>(std::forward<Args>(args)...), deathFuture);
        }

        std::shared_ptr<ICallbackQueue> workerQueue(std::string name) const;

        std::vector<std::weak_ptr<AsioAsyncObject>> asyncObjects();

    private:
        std::atomic_bool isRunning_{false};
        asio::io_context ioContext_;
        std::shared_ptr<void> asyncWorkGuard_;
        std::shared_ptr<AsioCallbackPool> asioCallbackPool_;
        std::thread ioThread_;

        std::shared_ptr<AsioAsyncObjectStorage> asioAsyncObjectStorage_;
    };

} // namespace quasar::ipc::detail::asio_ipc
