#pragma once
#include "asio_callback_queue.h"
#include <yandex_io/libs/threading/i_timer_service.h>

#include <deque>
#include <mutex>
#include <vector>

namespace quasar::ipc::detail::asio_ipc {

    class IAsioCallbackController {
    public:
        virtual ~IAsioCallbackController() = default;

        virtual void notifyDestroy() = 0;
        virtual void notifyTask(std::weak_ptr<AsioCallbackQueue> self) = 0;
        virtual void scheduleTask(std::weak_ptr<AsioCallbackQueue> self, std::function<void()> callback, std::chrono::milliseconds timeOut, Lifetime::Tracker tracker) = 0;
    };

    class AsioCallbackPool: public std::enable_shared_from_this<AsioCallbackPool> {
    public:
        AsioCallbackPool(std::string name, size_t threadCount, std::shared_ptr<ITimerService> timerService);
        ~AsioCallbackPool();

        std::shared_ptr<AsioCallbackQueue> createAsioCallbackQueue(std::string name);

        size_t size();
        void destroy();

    private:
        void workerLoop(size_t n);

    private:
        class Controller;
        const std::string name_;
        const size_t threadCount_;
        const std::shared_ptr<ITimerService> timerService_;
        const std::shared_ptr<std::atomic<size_t>> dirty_;
        const std::shared_ptr<Controller> controller_;

        std::vector<std::thread> workers_;

        std::mutex mutex_;
        std::condition_variable wakeUpCv_;
        bool shutdown_{false};
        bool stopped_{false};
        std::vector<std::weak_ptr<AsioCallbackQueue>> callbackQueues_;
        std::deque<std::weak_ptr<AsioCallbackQueue>> orderQueue_;
    };
} // namespace quasar::ipc::detail::asio_ipc
