#pragma once
#include <yandex_io/libs/threading/i_callback_queue.h>

#include <deque>
#include <mutex>

namespace quasar::ipc::detail::asio_ipc {

    class IAsioCallbackController;
    class AsioCallbackQueue
        : public ICallbackQueue,
          public std::enable_shared_from_this<AsioCallbackQueue> {
    public:
        struct Callback {
            std::function<void()> callback;
            Lifetime::Tracker tracker;
        };

        AsioCallbackQueue(std::string name, std::shared_ptr<IAsioCallbackController> controller);
        ~AsioCallbackQueue();

        std::atomic<std::thread::id>& worker();
        std::atomic<int32_t>& iterations();
        Callback pop() noexcept;
        void shutdown(); // schedule destroy and exit
        void destroy();  // shutdown and wait until finish

    public: // ICallbackQueue
        std::string name() const override;
        void add(std::function<void()> callback) override;
        void add(std::function<void()> callback, Lifetime::Tracker tracker) override;
        bool tryAdd(std::function<void()> callback) override;
        bool tryAdd(std::function<void()> callback, Lifetime::Tracker tracker) override;

        void addDelayed(std::function<void()> callback, std::chrono::milliseconds timeOut) override;
        void addDelayed(std::function<void()> callback, std::chrono::milliseconds timeOut, Lifetime::Tracker tracker) override;
        void wait(AwatingType awatingType = AwatingType::ALTRUIST) override;
        bool isWorkingThread() const noexcept override;
        size_t size() const override;
        void setMaxSize(size_t size) override;

    private:
        const std::string name_;
        const std::shared_ptr<IAsioCallbackController> controller_;
        std::atomic<std::thread::id> worker_;
        std::atomic<int32_t> iterations_{0};

        mutable std::mutex mutex_;
        std::deque<Callback> queue_;
        bool shutdown_{false};
        bool stopped_{false};
    };

} // namespace quasar::ipc::detail::asio_ipc
