#pragma once

#include "asio_async_object.h"
#include "asio_async_worker.h"
#include "length_value_tokenizer.h"

#include <yandex_io/libs/ipc/i_server.h>

#include <util/generic/fwd.h>
#include <util/generic/string.h>

#include <mutex>
#include <queue>
#include <string>
#include <string_view>
#include <vector>

#include <asio.hpp>

namespace quasar::ipc::detail::asio_ipc {

    class AsioChannel: public AsioAsyncObject, public std::enable_shared_from_this<AsioChannel> {
    public:
        AsioChannel(std::shared_ptr<AsioAsyncWorker> worker, asio::ip::tcp::socket sock, const std::string& serviceName);
        ~AsioChannel();

        void asyncSend(std::shared_ptr<TString> data);

        const std::string& serviceDescription() const {
            return serviceDescription_;
        }

        // From AsioAsyncObject

        void debugPrintDescription(std::ostream& out) const override;

    private:
        void doAsyncStart() override;
        void doAsyncShutdown() override;

    protected:
        virtual void onIpcConnect() = 0;
        virtual void onIpcDisconnect() = 0;
        virtual void onIpcConnectionError(std::string errorMessage) = 0;

        // return true if payload is ok, false if bad
        virtual bool onIpcMessage(asio::const_buffer buffer) = 0;

    private:
        void closeSocket();

        void asyncReadNext();
        void asyncSendImpl(std::shared_ptr<TString> data);
        void asyncSendNextLocked(std::unique_lock<std::mutex>& lock);

        std::vector<asio::const_buffer> prepareSendBufferLocked() const;

        void onReadData(const asio::error_code& ec, size_t bytesTransferred);
        void onSendData(const asio::error_code& ec, size_t bytesTransferred);

    private:
        const std::string serviceDescription_;

        asio::strand<asio::io_context::executor_type> strand_;
        asio::ip::tcp::socket socket_;
        // recv state
        std::vector<std::byte> readBuffer_; // FIXME: extra copy: asio read directly into tokenizer?
        LengthValueTokenizer readTokenizer_;
        // send state
        std::mutex sendQueueMutex_;
        std::deque<std::shared_ptr<TString>> sendQueue_;
        size_t sendOffset_{0};
    };

} // namespace quasar::ipc::detail::asio_ipc
