#pragma once

#include "asio_async_worker.h"
#include "asio_connector.h"

#include <yandex_io/libs/ipc/i_connector.h>

#include <yandex_io/libs/configuration/configuration.h>

namespace quasar::ipc::detail::asio_ipc {

    class AsioConnectorFacade: public ipc::IConnector {
    public:
        AsioConnectorFacade(std::string serviceName,
                            std::shared_ptr<YandexIO::Configuration> configuration,
                            std::shared_ptr<AsioAsyncWorker> worker);
        ~AsioConnectorFacade();

        // from ipc::IConnector
        const std::string& serviceName() const override;

        void setConnectHandler(OnConnect handler) override;
        void setDisconnectHandler(OnDisconnect handler) override;
        void setConnectionErrorHandler(OnConnectionError handler) override;
        void setMessageHandler(MessageHandler handler) override;
        void setSilentMode(bool silentMode) override;

        bool sendMessage(const SharedMessage& message) override;
        bool sendMessage(Message&& message) override;
        void sendRequest(UniqueMessage&& message, OnDone onDone, OnError onError, std::chrono::milliseconds timeout) override;
        void sendRequest(Message&& message, OnDone onDone, OnError onError, std::chrono::milliseconds timeout) override;
        SharedMessage sendRequestSync(UniqueMessage&& message, std::chrono::milliseconds timeout) override;
        SharedMessage sendRequestSync(Message&& message, std::chrono::milliseconds timeout) override;

        bool tryConnectToService() override;
        void connectToService() override;
        void connectToTcpHost(const std::string& hostname, int port) override;
        void connectToTcpLocal(int port) override;

        bool isConnected() const override;
        void waitUntilConnected() const override;
        void waitUntilDisconnected() const override;
        bool waitUntilConnected(const std::chrono::milliseconds& timeout) const override;
        bool waitUntilDisconnected(const std::chrono::milliseconds& timeout) const override;

        void shutdown() override;

        friend std::ostream& operator<<(std::ostream& out, const AsioConnectorFacade& connector);

    private:
        bool doSendMessage(const Message& message);
        void doSendRequest(Message& message, OnDone onDone, OnError onError, std::chrono::milliseconds timeout);
        SharedMessage doSendRequestSync(Message& message, std::chrono::milliseconds timeout);
        void doSyncShutdownUnlocked();

    private:
        const std::shared_ptr<YandexIO::Configuration> configuration_;
        const std::string serviceName_;

        mutable std::mutex mutex_;

        std::shared_ptr<AsioAsyncWorker> worker_;
        std::shared_ptr<AsioConnector::Callbacks> callbacks_;

        std::future<void> implDeath_;
        std::shared_ptr<AsioConnector> impl_;
    };

} // namespace quasar::ipc::detail::asio_ipc
