#include "asio_ipc_factory.h"

#include "asio_connector_facade.h"
#include "asio_server_facade.h"

#include <yandex_io/libs/base/named_callback_queue.h>

#include <util/system/yassert.h>

using namespace quasar;
using namespace quasar::ipc::detail::asio_ipc;

AsioIpcFactory::AsioIpcFactory(std::shared_ptr<YandexIO::Configuration> configuration)
    : AsioIpcFactory(std::move(configuration), std::make_shared<AsioAsyncWorker>())
{
}

AsioIpcFactory::AsioIpcFactory(std::shared_ptr<YandexIO::Configuration> configuration, std::shared_ptr<AsioAsyncWorker> asyncWorker)
    : configuration_(std::move(configuration))
    , asyncWorker_(std::move(asyncWorker))
{
    Y_VERIFY(configuration_ != nullptr);
    Y_VERIFY(asyncWorker_ != nullptr);

    asyncWorker_->startBackgroundThreads();
}

AsioIpcFactory::~AsioIpcFactory() {
    asyncWorker_->stopBackgroundThreads();
}

std::shared_ptr<ipc::IServer> AsioIpcFactory::createIpcServer(const std::string& serviceName) {
    return std::make_shared<AsioServerFacade>(serviceName, configuration_, asyncWorker_);
}

std::shared_ptr<ipc::IConnector> AsioIpcFactory::createIpcConnector(const std::string& serviceName) {
    return std::make_shared<AsioConnectorFacade>(serviceName, configuration_, asyncWorker_);
}
