#pragma once

#include <yandex_io/libs/ipc/i_ipc_factory.h>

#include <yandex_io/libs/configuration/configuration.h>

namespace quasar::ipc::detail::asio_ipc {

    class AsioAsyncWorker;

    class AsioIpcFactory: public IIpcFactory {
    public:
        explicit AsioIpcFactory(std::shared_ptr<YandexIO::Configuration> configuration);
        AsioIpcFactory(std::shared_ptr<YandexIO::Configuration> configuration, std::shared_ptr<AsioAsyncWorker> asyncWorker);
        ~AsioIpcFactory();

        std::shared_ptr<IServer> createIpcServer(const std::string& serviceName) override;
        std::shared_ptr<IConnector> createIpcConnector(const std::string& serviceName) override;

    private:
        const std::shared_ptr<YandexIO::Configuration> configuration_;
        std::shared_ptr<AsioAsyncWorker> asyncWorker_;
    };

} // namespace quasar::ipc::detail::asio_ipc

namespace quasar::ipc {

    using detail::asio_ipc::AsioIpcFactory;

} // namespace quasar::ipc
