#include "asio_logging.h"

using namespace quasar::ipc::detail::asio_ipc;

std::ostream& quasar::ipc::detail::asio_ipc::operator<<(std::ostream& out, AsioResultLog asioResult) {
    const auto& ec = asioResult.errorCode;
    if (!ec) {
        out << "Ok";
    } else {
        out << "Error(" << ec << "; " << ec.message() << ")";
    }
    return out;
}

std::ostream& quasar::ipc::detail::asio_ipc::operator<<(std::ostream& out, AsioTcpEndpointsLog endpoints) {
    auto outEndpoint = [&](const auto& ep, const auto& ec) {
        if (ec) {
            out << "<error " << ec << '>';
            return;
        }

        if (!ep.address().is_loopback()) {
            out << ep.address();
        } else {
            out << "LOCAL";
        }
        out << ':' << ep.port();
    };

    asio::error_code ec;
    out << '[';
    auto epLocal = endpoints.socket.local_endpoint(ec);
    outEndpoint(epLocal, ec);
    out << " <-> ";
    auto epRemote = endpoints.socket.remote_endpoint(ec);
    outEndpoint(epRemote, ec);
    out << ']';

    return out;
}
