#pragma once

#include <ostream>

#include <asio.hpp>

#define ASIO_IPC_RESULT_LOG(good__, bad__, ec__, message__)                           \
    if (Y_UNLIKELY(ec__ && ec__.value() != ENOENT && ec__.value() != ECONNREFUSED)) { \
        YIO_LOG_##bad__(message__ << ": " << AsioResultLog{ec__});                    \
    } else {                                                                          \
        YIO_LOG_##good__(message__ << ": Ok");                                        \
    }

namespace quasar::ipc::detail::asio_ipc {

    struct AsioResultLog {
        const asio::error_code& errorCode;

        friend std::ostream& operator<<(std::ostream& out, AsioResultLog asioResult);
    };

    struct AsioTcpEndpointsLog {
        const asio::ip::tcp::socket& socket;

        friend std::ostream& operator<<(std::ostream& out, AsioTcpEndpointsLog endpoints);
    };

} // namespace quasar::ipc::detail::asio_ipc
