#pragma once

#include "asio_async_worker.h"
#include "asio_server.h"
#include "asio_tcp_acceptor.h"

#include <yandex_io/libs/ipc/i_server.h>

#include <yandex_io/libs/configuration/configuration.h>

namespace quasar::ipc::detail::asio_ipc {

    class AsioServerFacade: public ipc::IServer {
    public:
        AsioServerFacade(std::string serviceName,
                         std::shared_ptr<YandexIO::Configuration> configuration,
                         std::shared_ptr<AsioAsyncWorker> worker);

        ~AsioServerFacade();

        // from ipc::IServer
        const std::string& serviceName() const override;

        void setMessageHandler(MessageHandler handler) override;
        void setClientConnectedHandler(ClientHandler handler) override;
        void setClientDisconnectedHandler(ClientHandler handler) override;

        void listenService() override;
        int listenTcpLocal(int port) override;
        void listenTcpHost(const std::string& hostname, int port) override;

        int port() const override;

        int getConnectedClientCount() const override;

        void waitConnectionsAtLeast(size_t count) override;
        bool waitConnectionsAtLeast(size_t count, std::chrono::milliseconds timeout) override;

        void waitListening() const override;
        bool waitListening(std::chrono::milliseconds timeout) const;

        void sendToAll(const SharedMessage& message) override;
        void sendToAll(Message&& message) override;

        void shutdown() override;

        friend std::ostream& operator<<(std::ostream& out, const AsioServerFacade& server);

    private:
        void doSendToAll(const Message& message);
        void doSyncShutdownUnlocked();
        void doListenTcpLocal(int port);

    private:
        const std::shared_ptr<YandexIO::Configuration> configuration_;
        const std::string serviceName_;

        mutable std::mutex mutex_;

        Lifetime lifetime_;
        std::shared_ptr<AsioAsyncWorker> worker_;
        std::shared_ptr<AsioServer::Callbacks> callbacks_;

        std::future<void> implDeath_;
        std::shared_ptr<AsioServer> impl_;
    };

} // namespace quasar::ipc::detail::asio_ipc
