#pragma once

#include "asio_async_object.h"
#include "asio_async_worker.h"
#include "asio_channel.h"

#include <yandex_io/libs/threading/steady_condition_variable.h>

#include <memory>
#include <set>

#include <asio.hpp>

namespace quasar::ipc::detail::asio_ipc {

    class AsioTcpAcceptor: public AsioAsyncObject, public std::enable_shared_from_this<AsioTcpAcceptor> {
    public:
        struct Address {
            int port = -1;

            friend std::ostream& operator<<(std::ostream& out, const Address& address);
        };

        struct Callbacks {
            std::function<void()> onListen;
            std::function<void()> onStopListening;
            std::function<void(asio::ip::tcp::socket peer)> onConnect;

            void verify() const;
        };

    public:
        AsioTcpAcceptor(std::shared_ptr<AsioAsyncWorker> worker, std::string serviceName, Address address, Callbacks callbacks);
        ~AsioTcpAcceptor();

        // From AsioAsyncObject
        void debugPrintDescription(std::ostream& out) const override;

    private:
        void doAsyncStart() override;
        void doAsyncShutdown() override;

    private:
        void listen();

        void asyncRetryListen(const asio::error_code& ec);
        void asyncAccept();

        void onRetryListen(const asio::error_code& ec);
        void onAcceptIncomingConnection(const asio::error_code& acceptErrorCode, asio::ip::tcp::socket peer);

    private:
        const std::string serviceName_;
        const Address address_;
        const Callbacks callbacks_;

        asio::strand<asio::io_context::executor_type> strand_;
        asio::ip::tcp::acceptor acceptor_;
        asio::steady_timer retryTimer_;
    };

} // namespace quasar::ipc::detail::asio_ipc
