#pragma once

#include "asio_async_object.h"
#include "asio_async_worker.h"
#include "asio_channel.h"

#include <yandex_io/libs/threading/steady_condition_variable.h>

#include <memory>
#include <mutex>
#include <type_traits>
#include <variant>

#include <asio.hpp>

namespace quasar::ipc::detail::asio_ipc {

    class AsioTcpConnector: public AsioAsyncObject, public std::enable_shared_from_this<AsioTcpConnector> {
    public:
        struct Address {
            std::string hostname;
            int port = -1;

            friend std::ostream& operator<<(std::ostream& out, const Address& address);
        };

        struct StopTrying {
        };

        struct RetryAfter {
            std::chrono::milliseconds delay;
        };

        using RetryAction = std::variant<StopTrying, RetryAfter>;

        struct Callbacks {
            std::function<void(asio::ip::tcp::socket peer)> onConnect;
            std::function<RetryAction()> onConnectionFailure;

            void verify() const;
        };

    public:
        AsioTcpConnector(std::shared_ptr<AsioAsyncWorker> worker, std::string serviceName, Address address, Callbacks callbacks);
        ~AsioTcpConnector();

        // From AsioAsyncObject
        void debugPrintDescription(std::ostream& out) const override;

    private:
        void doAsyncStart() override;
        void doAsyncShutdown() override;

    private:
        using EndpointIterator = asio::ip::tcp::resolver::results_type::const_iterator;

    private:
        void asyncResolveEndpoint();
        void asyncConnectEndpoint(EndpointIterator epBegin, EndpointIterator epEnd);
        void asyncRetryConnect(const asio::error_code& ec);

        void onResolveEndpoint(const asio::error_code& ec, asio::ip::tcp::resolver::results_type results);
        void onConnectEndpoint(const asio::error_code& ec, std::shared_ptr<asio::ip::tcp::socket> sockPtr, EndpointIterator epBegin, EndpointIterator epEnd);
        void onRetryConnect(const asio::error_code& ec);

        void setConnection(std::shared_ptr<AsioChannel> connection);

    private:
        std::string serviceName_;
        Address address_;
        Callbacks callbacks_;

        asio::strand<asio::io_context::executor_type> strand_;
        asio::ip::tcp::resolver resolver_;
        asio::steady_timer retryTimer_;
    };

} // namespace quasar::ipc::detail::asio_ipc
