#pragma once

#include <asio/buffer.hpp>

namespace quasar::ipc::detail::asio_ipc {

    class LengthValueTokenizer {
    public:
        using OnMessage = std::function<bool(asio::const_buffer message)>;

    public:
        LengthValueTokenizer();

        bool pushData(asio::const_buffer data, OnMessage onMessage);

        size_t maxSize() const {
            return maxSize_;
        }

    private:
        void appendData(asio::const_buffer data);
        void advanceData(size_t bytesToSkip);

    private:
        std::vector<std::byte> currentData_;
        size_t maxSize_{0};
    };

} // namespace quasar::ipc::detail::asio_ipc
