#include "serialize.h"

#include <yandex_io/protos/quasar_proto.pb.h>

#include <util/system/byteorder.h>

using namespace quasar::ipc::detail::asio_ipc;

void quasar::ipc::detail::asio_ipc::SerializeToStringWithFraming(const proto::QuasarMessage& message, TString* buffer) {
    static constexpr size_t HEADER_SIZE = sizeof(int32_t);

    buffer->reserve(HEADER_SIZE + message.ByteSizeLong());
    buffer->resize(HEADER_SIZE);
    Y_PROTOBUF_SUPPRESS_NODISCARD message.AppendToString(buffer);

    int32_t size = HostToLittle<int32_t>(buffer->size() - HEADER_SIZE);
    memcpy(&*buffer->begin(), &size, sizeof(size));
}

std::shared_ptr<TString> quasar::ipc::detail::asio_ipc::SerializeToSharedBufferWithFraming(const proto::QuasarMessage& message) {
    auto buffer = std::make_shared<TString>();
    SerializeToStringWithFraming(message, buffer.get());
    return buffer;
}

std::shared_ptr<TString> quasar::ipc::detail::asio_ipc::MakeSharedBuffer(std::string_view data) {
    return std::make_shared<TString>(data);
}
