#pragma once

#include <yandex_io/protos/quasar_proto_forward.h>

#include <util/generic/fwd.h>
#include <util/generic/string.h>

#include <memory>
#include <string>
#include <string_view>

namespace quasar::ipc::detail::asio_ipc {

    void SerializeToStringWithFraming(const proto::QuasarMessage& message, TString* buffer);

    std::shared_ptr<TString> SerializeToSharedBufferWithFraming(const proto::QuasarMessage& message);

    std::shared_ptr<TString> MakeSharedBuffer(std::string_view data);

} // namespace quasar::ipc::detail::asio_ipc
