#pragma once

#include <list>
#include <map>
#include <mutex>
#include <string>

namespace quasar {

    class ConnectionsStateHolder {
    public:
        ConnectionsStateHolder(const std::list<std::string>& services);

        void connect(const std::string& service);
        void disconnect(const std::string& service);
        bool isConnected(const std::string& service);
        void addService(const std::string& service);
        void deleteService(const std::string& service);
        bool allConnected();

    private:
        void checkHasService(const std::string& service);
        std::mutex mutex_;
        using IsConnectedState = bool;
        std::map<std::string, IsConnectedState> connectionsMap_;
    };
} // namespace quasar
