#include "datacratic_ipc_factory.h"

#include "quasar_connector.h"
#include "quasar_server.h"

using namespace quasar;
using namespace quasar::ipc::detail::datacratic;

DatacraticIpcFactory::DatacraticIpcFactory(std::shared_ptr<YandexIO::Configuration> configuration)
    : configuration_(std::move(configuration))
{
}

std::shared_ptr<ipc::IServer> DatacraticIpcFactory::createIpcServer(const std::string& serviceName) {
    return std::make_shared<QuasarServer>(serviceName, configuration_);
}

std::shared_ptr<ipc::IConnector> DatacraticIpcFactory::createIpcConnector(const std::string& serviceName) {
    return std::make_shared<QuasarConnector>(serviceName, configuration_);
}
