#pragma once

#include <yandex_io/libs/ipc/i_ipc_factory.h>

#include <yandex_io/libs/configuration/configuration.h>

#include <memory>

namespace quasar::ipc::detail::datacratic {

    class DatacraticIpcFactory: public IIpcFactory {
    public:
        explicit DatacraticIpcFactory(std::shared_ptr<YandexIO::Configuration> configuration);
        std::shared_ptr<IServer> createIpcServer(const std::string& serviceName) override;
        std::shared_ptr<IConnector> createIpcConnector(const std::string& serviceName) override;

    private:
        const std::shared_ptr<YandexIO::Configuration> configuration_;
    };

} // namespace quasar::ipc::detail::datacratic

namespace quasar::ipc {

    using detail::datacratic::DatacraticIpcFactory;

} // namespace quasar::ipc
