#include "length_value_tokenizer.h"

using namespace quasar;
using namespace quasar::ipc::detail::datacratic;

void LengthValueTokenizer::pushData(const std::string& data)
{
    for (const char& ch : data)
    {
        if (!lengthReceived())
        {
            currentLength_ |= (int32_t(uint8_t(ch)) << lengthBitsReceived_);
            lengthBitsReceived_ += 8;
        } else {
            currentData_ += ch;
        }
        Y_VERIFY(lengthBitsReceived_ <= 4 * 8);
        if (lengthReceived() && currentData_.length() == currentLength_)
        {
            onToken(currentData_);
            currentData_.clear();
            currentLength_ = 0;
            lengthBitsReceived_ = 0;
        }
    }
}

std::string LengthValueTokenizer::getLengthValue(const std::string& data)
{
    std::string result;
    result.reserve(data.length() + 4);

    const int32_t length = data.length();
    result.insert(0, reinterpret_cast<const char*>(&length), 4);

    result += data;

    return result;
}
