#pragma once

#include "tokenizer.h"

#include <util/system/yassert.h>

namespace quasar::ipc::detail::datacratic {

    struct LengthValueTokenizer: public Tokenizer {
        void pushData(const std::string& data) override;

        static std::string getLengthValue(const std::string& data);

    private:
        bool lengthReceived() const {
            Y_VERIFY(lengthBitsReceived_ <= 4 * 8);
            return 4 * 8 == lengthBitsReceived_;
        }

        uint32_t currentLength_ = 0;
        int lengthBitsReceived_ = 0;
        std::string currentData_;
    };

} // namespace quasar::ipc::detail::datacratic
