#include "public.h"

#include "quasar_connector.h"
#include "quasar_server.h"

using namespace quasar::ipc;

std::shared_ptr<IConnector> quasar::ipc::datacratic::createIpcConnector(std::string serviceName, std::shared_ptr<YandexIO::Configuration> configuration) {
    return std::make_shared<detail::datacratic::QuasarConnector>(std::move(serviceName), std::move(configuration));
}

std::shared_ptr<IServer> quasar::ipc::datacratic::createIpcServer(std::string serviceName, std::shared_ptr<YandexIO::Configuration> configuration) {
    return std::make_shared<detail::datacratic::QuasarServer>(std::move(serviceName), std::move(configuration));
}
