#pragma once

#include "quasar_connector_impl.h"

#include <yandex_io/libs/ipc/i_connector.h>

#include <yandex_io/libs/configuration/configuration.h>

namespace quasar::ipc::detail::datacratic {

    class QuasarConnector: public ipc::IConnector {
        QuasarConnectorImpl impl_;

    public:
        QuasarConnector(std::string serviceName, std::shared_ptr<YandexIO::Configuration> configuration);
        QuasarConnector(std::string serviceName, std::shared_ptr<YandexIO::Configuration> configuration, const Lifetime& /*lifetime*/, std::shared_ptr<ICallbackQueue> /*callbackQueue*/);

        ~QuasarConnector();

        const std::string& serviceName() const override;

        // Set options/callbacks
        void setConnectHandler(OnConnect handler) override;
        void setDisconnectHandler(OnDisconnect handler) override;
        void setConnectionErrorHandler(OnConnectionError handler) override;
        void setMessageHandler(MessageHandler handler) override;
        void setSilentMode(bool silentMode) override;

        // EventBus mode
        bool sendMessage(const ipc::SharedMessage& message) override;
        bool sendMessage(ipc::Message&& message) override;

        // Request-Reply mode
        void sendRequest(ipc::UniqueMessage&& message, OnDone onDone, OnError onError, std::chrono::milliseconds timeout) override;
        void sendRequest(ipc::Message&& message, OnDone onDone, OnError onError, std::chrono::milliseconds timeout) override;
        ipc::SharedMessage sendRequestSync(ipc::UniqueMessage&& message, std::chrono::milliseconds timeout) override;
        ipc::SharedMessage sendRequestSync(ipc::Message&& message, std::chrono::milliseconds timeout) override;

        bool tryConnectToService() override;
        void connectToService() override;
        void connectToTcpHost(const std::string& hostname, int port) override;
        void connectToTcpLocal(int port) override;

        bool isConnected() const override;
        void waitUntilConnected() const override;
        void waitUntilDisconnected() const override;
        bool waitUntilConnected(const std::chrono::milliseconds& duration) const override;
        bool waitUntilDisconnected(const std::chrono::milliseconds& duration) const override;

        void shutdown() override;
    };

} // namespace quasar::ipc::detail::datacratic
