#pragma once

#include "quasar_server_impl.h"

#include <yandex_io/libs/ipc/i_server.h>

#include <yandex_io/libs/configuration/configuration.h>

namespace quasar::ipc::detail::datacratic {

    class QuasarServer: public ipc::IServer {
        QuasarServerImpl impl_;
        std::string serviceName_;

    public:
        QuasarServer(std::string serviceName, std::shared_ptr<YandexIO::Configuration> configuration);
        QuasarServer(std::string serviceName, std::shared_ptr<YandexIO::Configuration> configuration, const Lifetime& lifetime, std::shared_ptr<ICallbackQueue> callbackQueue);

        ~QuasarServer();

        const std::string& serviceName() const override;

        void setMessageHandler(MessageHandler handler) override;
        void setClientConnectedHandler(ClientHandler handler) override;
        void setClientDisconnectedHandler(ClientHandler handler) override;

        void listenService() override;
        int listenTcpLocal(int port) override;
        void listenTcpHost(const std::string& hostname, int port) override;

        int port() const override;

        int getConnectedClientCount() const override;
        void waitConnectionsAtLeast(size_t count) override;
        bool waitConnectionsAtLeast(size_t count, std::chrono::milliseconds timeout) override;

        void waitListening() const override;

        void sendToAll(const SharedMessage& message) override;
        void sendToAll(quasar::proto::QuasarMessage&& message) override;

        void shutdown() override;
    };

} // namespace quasar::ipc::detail::datacratic
