#pragma once

#include "tcp_endpoint.h"

#include <yandex_io/libs/configuration/configuration.h>
#include <yandex_io/libs/threading/i_callback_queue.h>
#include <yandex_io/libs/threading/lifetime.h>

#include <yandex_io/external_libs/datacratic/soa/service/passive_endpoint.h>
#include <yandex_io/protos/quasar_proto_forward.h>

namespace quasar::ipc::detail::datacratic {

    class QuasarServerImpl: public TCPEndpoint {
        QuasarServerImpl(Lifetime::Tracker tracker, std::shared_ptr<YandexIO::Configuration> configuration, std::shared_ptr<ICallbackQueue> callbackQueue);

    public:
        using MessageHandler = std::function<void(const SharedMessage& message, TCPConnectionHandler* connection)>;

        explicit QuasarServerImpl(std::shared_ptr<YandexIO::Configuration> configuration);
        QuasarServerImpl(const std::string& serviceName, std::shared_ptr<YandexIO::Configuration> configuration);
        QuasarServerImpl(const Lifetime& lifetime, std::shared_ptr<YandexIO::Configuration> configuration, std::shared_ptr<ICallbackQueue> callbackQueue);

        ~QuasarServerImpl();

        void setMessageHandler(MessageHandler handler);
        void setClientConnectedHandler(ClientHandler handler) override;
        void setClientDisconnectedHandler(ClientHandler handler) override;

        void initService(const std::string& serviceName);
        void initService(const std::string& hostname, int port);

        void sendToAll(const quasar::proto::QuasarMessage& message);
        static void send(const quasar::proto::QuasarMessage& message, TCPConnectionHandler* handler);

    private:
        ClientHandler makeClientHandlerForCallbackQueue(ClientHandler handler);
        void handleMessage(const std::string& message, const std::shared_ptr<TCPConnectionHandler>& handler);

    private:
        const std::shared_ptr<YandexIO::Configuration> configuration_;
        const Lifetime::Tracker tracker_;
        const std::shared_ptr<ICallbackQueue> callbackQueue_;
        std::shared_ptr<const std::string> serviceName_;

        MessageHandler onQuasarMessage_;
    };

} // namespace quasar::ipc::detail::datacratic
