#pragma once

#include <functional>
#include <string>

namespace quasar::ipc::detail::datacratic {

    struct Tokenizer {
        virtual void pushData(const std::string& data) = 0;

        virtual ~Tokenizer() {
        }

        std::function<void(const std::string& message)> onToken;
    };

    struct LineTokenizer: public Tokenizer {
        void pushData(const std::string& data) override;

    private:
        std::string current_;
    };

} // namespace quasar::ipc::detail::datacratic
