#pragma once

#include "i_connector.h"
#include "i_server.h"

#include <memory>

namespace quasar::ipc {

    class IIpcFactory {
    public:
        virtual ~IIpcFactory() = default;

        virtual std::shared_ptr<IServer> createIpcServer(const std::string& serviceName) = 0;
        virtual std::shared_ptr<IConnector> createIpcConnector(const std::string& serviceName) = 0;
    };

} // namespace quasar::ipc
