#pragma once

#include "message.h"

#include <yandex_io/libs/threading/i_callback_queue.h>
#include <yandex_io/libs/threading/lifetime.h>

#include <yandex_io/protos/quasar_proto_forward.h>

#include <chrono>
#include <functional>
#include <memory>
#include <string>
#include <string_view>

namespace quasar::ipc {

    class IServer {
    public:
        class IClientConnection {
        public:
            virtual ~IClientConnection();

            virtual std::shared_ptr<IClientConnection> share() = 0;
            std::weak_ptr<IClientConnection> weak() {
                return share();
            }

            virtual void send(const SharedMessage& message) = 0;
            YIO_IPC_DEPRECATED_MESSAGE_API virtual void send(Message&& message) = 0;
            virtual void unsafeSendBytes(std::string_view data) = 0;

            virtual void scheduleClose() = 0;
        };

        using MessageHandler = std::function<void(const SharedMessage& message, IClientConnection& connection)>;
        using ClientHandler = std::function<void(IClientConnection& connection)>;

        virtual ~IServer();

        virtual const std::string& serviceName() const = 0;

        virtual void setMessageHandler(MessageHandler handler) = 0;
        virtual void setClientConnectedHandler(ClientHandler handler) = 0;
        virtual void setClientDisconnectedHandler(ClientHandler handler) = 0;

        virtual void listenService() = 0;
        virtual int listenTcpLocal(int port) = 0;
        virtual void listenTcpHost(const std::string& hostname, int port) = 0;

        virtual int port() const = 0;

        virtual int getConnectedClientCount() const = 0;

        /**
         * @brief Wait until there are at least `count` connections to endpoint
         */
        virtual void waitConnectionsAtLeast(size_t count) = 0;
        virtual bool waitConnectionsAtLeast(size_t count, std::chrono::milliseconds timeout) = 0;

        virtual void waitListening() const = 0;

        virtual void sendToAll(const SharedMessage& message) = 0;
        YIO_IPC_DEPRECATED_MESSAGE_API virtual void sendToAll(Message&& message) = 0;

        virtual void shutdown() = 0;
    };

} // namespace quasar::ipc
