#include "message.h"

#include <yandex_io/libs/protobuf_utils/json.h>

#include <yandex_io/protos/quasar_proto.pb.h>

using namespace quasar;
using namespace quasar::ipc;

std::shared_ptr<Message> UniqueMessage::newMessage() {
    return std::make_shared<Message>();
}

std::shared_ptr<Message> UniqueMessage::newMessage(const Message& msg) {
    return std::make_shared<Message>(msg);
}

std::shared_ptr<Message> UniqueMessage::newMessage(Message&& msg) {
    return std::make_shared<Message>(std::move(msg));
}

std::ostream& operator<<(std::ostream& os, const quasar::ipc::Message& message) {
    return os << convertMessageToJsonString(message);
}

std::ostream& operator<<(std::ostream& os, const quasar::ipc::UniqueMessage& message) {
    return os << (message ? convertMessageToJsonString(*message) : "(nullptr)");
}

std::ostream& operator<<(std::ostream& os, const quasar::ipc::SharedMessage& message) {
    return os << (message ? convertMessageToJsonString(*message) : "(nullptr)");
}
