#pragma once
#include "i_mixed_server.h"
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/threading/lifetime.h>

namespace YandexIO {
    class Configuration;
} // namespace YandexIO

namespace quasar::ipc::detail::mixed {

    class IMixedIpcFactory: public IIpcFactory {
    public:
        enum class Transport {
            DEFAULT,
            NET,
            LOCAL,
            MIXED,
        };

        enum class NetImplementation {
            LEGACY,
            ASIO,
            CUSTOM,
        };

        enum class Purpose {
            FACTORY,
            MIXED_SERVER,
            MIXED_CONNECTOR,
            NET_SERVER,
            NET_CONNECTOR
        };

        struct Context {
            using CallbackQueueCreator = std::function<std::shared_ptr<ICallbackQueue>(const std::string&, Purpose, bool)>;
            using NetServerCreator = std::function<std::shared_ptr<IServer>(std::string serviceName, const Lifetime::Tracker&, const std::shared_ptr<ICallbackQueue>&)>;
            using NetConnectorCreator = std::function<std::shared_ptr<IConnector>(std::string serviceName, const Lifetime::Tracker&, const std::shared_ptr<ICallbackQueue>&)>;

            std::shared_ptr<YandexIO::Configuration> configuration;
            Transport transport{Transport::MIXED};
            NetImplementation netImplementation{NetImplementation::LEGACY};
            CallbackQueueCreator callbackQueueCreator;
            NetServerCreator customNetServerCreator;
            NetConnectorCreator customNetConnectorCreator;
            std::shared_ptr<ICallbackQueue> factoryCallbackQueue;
        };

        virtual std::shared_ptr<Context> context() const = 0;
        virtual std::string processName() const = 0;
        std::shared_ptr<IServer> createIpcServer(const std::string& serviceName) override = 0;
        std::shared_ptr<IConnector> createIpcConnector(const std::string& serviceName) override = 0;
        virtual std::shared_ptr<IServer> createIpcServer(IMixedServer::ListenerWeak listener, const std::string& serviceName, Transport transport, Purpose purpose, std::shared_ptr<ICallbackQueue> callbackQueue) = 0;
        virtual std::shared_ptr<IConnector> createIpcConnector(const std::string& serviceName, Transport transport, Purpose purpose, std::shared_ptr<ICallbackQueue> callbackQueue) = 0;
        virtual std::shared_ptr<IServer> findIpcServer(const std::string& serviceName) const = 0;
    };

} // namespace quasar::ipc::detail::mixed

namespace quasar::ipc {
    using detail::mixed::IMixedIpcFactory;
} // namespace quasar::ipc