#pragma once
#include <yandex_io/libs/ipc/i_server.h>

namespace quasar::ipc::detail::mixed {
    class IMixedServer: public ipc::IServer {
    public:
        class Listener {
        public:
            virtual ~Listener();
            virtual void onMixedServerListen(const std::string& serviceName) = 0;
            virtual void onMixedServerShutdown(const std::string& serviceName) = 0;
        };
        using ListenerWeak = std::weak_ptr<Listener>;

        class LocalConnection: public ipc::IServer::IClientConnection {
        public:
            virtual ~LocalConnection() = default;

            virtual void onConnect() = 0;
            virtual void onDisconnect() = 0;
            void unsafeSendBytes(std::string_view data) final;
        };

        virtual ~IMixedServer() = default;
        virtual bool isStarted() const = 0;
        virtual void addLocalConnection(const std::shared_ptr<LocalConnection>& localConnection) = 0;
        virtual void removeLocalConnection(const std::shared_ptr<LocalConnection>& localConnection) = 0;
        virtual void messageFromLocalConnection(const SharedMessage& message, LocalConnection& localConnection) = 0;
    };
} // namespace quasar::ipc::detail::mixed
