#pragma once

#include "i_mixed_ipc_factory.h"
#include "mixed_connector.h"
#include "mixed_server.h"

#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/signals/i_signal.h>
#include <yandex_io/libs/signals/signal.h>

#include <yandex_io/libs/configuration/configuration.h>

#include <map>
#include <memory>
#include <mutex>

namespace quasar::ipc::detail::mixed {

    class MixedIpcFactory: public IMixedIpcFactory {
    public:
        static std::shared_ptr<Context> createDefaultContext(std::shared_ptr<YandexIO::Configuration> configuration);

        MixedIpcFactory(std::shared_ptr<Context> context);
        MixedIpcFactory(std::shared_ptr<Context> context, std::string processName);
        ~MixedIpcFactory();

        void setProcessName(std::string processName);

    public: // IMixedIpcFactory
        std::shared_ptr<Context> context() const override;
        std::string processName() const override;
        std::shared_ptr<IServer> createIpcServer(IMixedServer::ListenerWeak listener, const std::string& serviceName, Transport transport, Purpose purpose, std::shared_ptr<ICallbackQueue> callbackQueue) override;
        std::shared_ptr<IConnector> createIpcConnector(const std::string& serviceName, Transport transport, Purpose purpose, std::shared_ptr<ICallbackQueue> callbackQueue) override;
        std::shared_ptr<IServer> findIpcServer(const std::string& serviceName) const override;

    public: // IIpcFactory
        std::shared_ptr<IServer> createIpcServer(const std::string& serviceName) override;
        std::shared_ptr<IConnector> createIpcConnector(const std::string& serviceName) override;

    private:
        Transport serviceTransport(const std::string& serviceName) const;
        bool sniff(const std::string& serviceName) const;
        void cleanupExpired(const std::string& serviceName) noexcept;
        std::shared_ptr<IServer> cretePureNetServerUnsafe(const std::string& serviceName, Transport transport);
        std::shared_ptr<IConnector> cretePureNetConnectorUnsafe(const std::string& serviceName, Transport transport);
        std::function<void(MixedServer*)> makeMixedServerDeleter();
        std::function<void(MixedConnector*)> makeMixedConnectorDeleter();
        void dumpStatistic() const;
        std::string processNameUnsafe() const;

    private:
        Lifetime lifetime_;
        const std::shared_ptr<Context> context_;
        std::shared_ptr<MixedServer::Listener> mixedServerListener_;

        mutable std::mutex mutex_;
        std::string processName_;
        std::map<std::string, std::weak_ptr<MixedServer>> servers_;
        std::map<std::string, std::list<std::weak_ptr<MixedConnector>>> connectors_;
    };

} // namespace quasar::ipc::detail::mixed

namespace quasar::ipc {
    using detail::mixed::MixedIpcFactory;
} // namespace quasar::ipc
