#pragma once
#include <yandex_io/libs/ipc/i_connector.h>

#include <yandex_io/protos/quasar_proto.pb.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace quasar::ipc::mock {

    class Connector: public IConnector {
    public:
        MOCK_METHOD(const std::string&, serviceName, (), (const, override));
        MOCK_METHOD(void, setConnectHandler, (OnConnect), (override));
        MOCK_METHOD(void, setDisconnectHandler, (OnDisconnect), (override));
        MOCK_METHOD(void, setConnectionErrorHandler, (OnConnectionError), (override));
        MOCK_METHOD(void, setMessageHandler, (MessageHandler), (override));
        MOCK_METHOD(void, setSilentMode, (bool), (override));

        MOCK_METHOD(bool, sendMessage, (const SharedMessage&), (override));
        MOCK_METHOD(bool, sendMessage, (Message &&), (override));

        MOCK_METHOD(void, sendRequest, (UniqueMessage&&, OnDone, OnError, std::chrono::milliseconds), (override));
        MOCK_METHOD(void, sendRequest, (Message&&, OnDone, OnError, std::chrono::milliseconds), (override));

        MOCK_METHOD(SharedMessage, sendRequestSync, (UniqueMessage&&, std::chrono::milliseconds), (override));
        MOCK_METHOD(SharedMessage, sendRequestSync, (Message&&, std::chrono::milliseconds), (override));

        MOCK_METHOD(bool, tryConnectToService, (), (override));
        MOCK_METHOD(void, connectToService, (), (override));
        MOCK_METHOD(void, connectToTcpHost, (const std::string&, int), (override));
        MOCK_METHOD(void, connectToTcpLocal, (int), (override));
        MOCK_METHOD(bool, isConnected, (), (const, override));

        MOCK_METHOD(void, waitUntilConnected, (), (const, override));
        MOCK_METHOD(void, waitUntilDisconnected, (), (const, override));
        MOCK_METHOD(bool, waitUntilConnected, (const std::chrono::milliseconds&), (const, override));
        MOCK_METHOD(bool, waitUntilDisconnected, (const std::chrono::milliseconds&), (const, override));

        MOCK_METHOD(void, shutdown, (), (override));
    };

} // namespace quasar::ipc::mock
