#pragma once

#include <yandex_io/libs/ipc/i_server.h>

#include <yandex_io/protos/quasar_proto.pb.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace quasar::ipc::mock {

    struct ClientConnection: public IServer::IClientConnection,
                             public std::enable_shared_from_this<ClientConnection> {
    public:
        std::shared_ptr<IClientConnection> share() override {
            return shared_from_this();
        }

        MOCK_METHOD(void, send, (const SharedMessage&), (override));
        MOCK_METHOD(void, send, (Message &&), (override));
        MOCK_METHOD(void, unsafeSendBytes, (std::string_view), (override));
        MOCK_METHOD(void, scheduleClose, (), (override));
    };

    class Server: public IServer {
    public:
        MOCK_METHOD(const std::string&, serviceName, (), (const, override));
        MOCK_METHOD(void, setMessageHandler, (MessageHandler), (override));
        MOCK_METHOD(void, setClientConnectedHandler, (ClientHandler), (override));
        MOCK_METHOD(void, setClientDisconnectedHandler, (ClientHandler), (override));

        MOCK_METHOD(void, listenService, (), (override));
        MOCK_METHOD(int, listenTcpLocal, (int), (override));
        MOCK_METHOD(void, listenTcpHost, (const std::string&, int), (override));

        MOCK_METHOD(int, port, (), (const, override));

        MOCK_METHOD(int, getConnectedClientCount, (), (const, override));

        MOCK_METHOD(void, waitConnectionsAtLeast, (size_t), (override));
        MOCK_METHOD(bool, waitConnectionsAtLeast, (size_t, std::chrono::milliseconds), (override));

        MOCK_METHOD(void, waitListening, (), (const, override));

        MOCK_METHOD(void, sendToAll, (const SharedMessage&), (override));
        MOCK_METHOD(void, sendToAll, (Message &&), (override));

        MOCK_METHOD(void, shutdown, (), (override));
    };

} // namespace quasar::ipc::mock
