#pragma once

#include "jwt_value.h"

#include <contrib/libs/libjwt/include/jwt.h>

#include <memory>
#include <string>
#include <unordered_map>

namespace quasar {

    class JwtDeleter {
    public:
        void operator()(jwt_t* ptr) noexcept {
            jwt_free(ptr);
        }
    };

    class JwtStringDeleter {
    public:
        void operator()(char* ptr) noexcept {
            jwt_free_str(ptr);
        }
    };

    using JwtPtr = std::unique_ptr<jwt_t, JwtDeleter>;
    using JwtStringPtr = std::unique_ptr<char, JwtStringDeleter>;

    std::string encodeJWT(const std::unordered_map<std::string, JwtValue>& values, jwt_alg_t alg = JWT_ALG_HS256,
                          const std::string& key = "");
    JwtPtr decodeJWT(const std::string& token, const std::string& key = "");

    long getLongGrantFromJWT(jwt_t* token, const std::string& grantName);

    //! returns false if grant is absent
    bool getBoolOrFalseGrantFromJWT(jwt_t* token, const std::string& grantName);

    std::string getStringGrantFromJWT(jwt_t* token, const std::string& grantName);
} // namespace quasar
