#include "jwt_value.h"

#include <yandex_io/libs/errno/errno_exception.h>

#include <cerrno>
#include <cstdlib>
#include <cstring>
#include <stdexcept>

using namespace quasar;

JwtValue::JwtValue(long value) {
    value_.long_ = value;
    type_ = Type::LONG;
}

JwtValue::JwtValue(const char* value) {
    value_.string_ = strdup(value);
    if (!value_.string_) {
        throw ErrnoException(errno, "Failed to initialize JwtValue from string");
    }
    length_ = strlen(value);
    type_ = Type::STRING;
}

JwtValue::JwtValue(const JwtValue& other) {
    type_ = other.type_;
    switch (type_) {
        case Type::LONG:
            value_.long_ = other.value_.long_;
            break;
        case Type::STRING:
            value_.string_ = strdup(other.value_.string_);
            if (!value_.string_) {
                throw ErrnoException(errno, "Failed to copy string from JwtValue");
            }
            length_ = other.length_;
            break;
    }
}

long JwtValue::asLong() const {
    if (type_ != Type::LONG) {
        throw std::runtime_error("JwtValue does not contain Long value");
    }
    return value_.long_;
}

std::string JwtValue::asString() const {
    if (type_ != Type::STRING) {
        throw std::runtime_error("JwtValue does not contain String value");
    }
    if (value_.string_ != nullptr) {
        return std::string(value_.string_, length_);
    } else {
        throw std::runtime_error("JwtValue does not contain string value");
    }
}

JwtValue::Type JwtValue::getType() const {
    return type_;
}

JwtValue::~JwtValue() {
    if (type_ == Type::STRING) {
        free(value_.string_);
    }
}
