#pragma once

#include <string>

class JwtValue {
public:
    enum class Type {
        LONG,
        STRING
    };

    JwtValue(long value);
    JwtValue(const char* value);
    JwtValue(const JwtValue& other);
    ~JwtValue();

    long asLong() const;
    std::string asString() const;

    JwtValue::Type getType() const;

private:
    union ValueHolder {
        long long_;
        char* string_;
    } value_;

    size_t length_;
    Type type_;
};
