#include <yandex_io/libs/keymaster_proxy_client/keymaster_proxy_client.h>
#include <yandex_io/libs/logging/logging.h>
#include <yandex_io/libs/logging/setup/setup.h>
#include <yandex_io/libs/telemetry/null/null_metrica.h>

#include <json/json.h>

#include <fstream>
#include <iostream>

using namespace quasar;
using namespace quasar::keymaster_proxy_client;

int RunKeymasterProxyApp(int argc, char** argv) {
    Logging::initLoggingToStdout("debug");

    const std::string usageStr =
        "Usage: keymaster_proxy_app path_to_socket operation [input file] [output file]\n"
        "Possible operations: [sign|decrypt|show-key|upgrade-key]";

    if (argc < 3) {
        std::cerr << usageStr << std::endl;
        return -1;
    }

    const std::string socketPath(argv[1]);
    KeymasterProxyClient s(socketPath);

    const std::string operation(argv[2]);

    if (operation == "show-key") {
        std::cout << '\n'
                  << s.exportKey() << std::endl;
        return 0;
    } else if (operation == "upgrade-key") {
        std::cout << '\n'
                  << s.upgradeKey() << std::endl;
        return 0;
    }

    if (argc < 5) {
        std::cerr << usageStr << std::endl;
        return -1;
    }

    std::string infile = argv[3];
    std::ifstream inputFile(infile.c_str(), std::ifstream::binary);
    std::string text;
    if (inputFile) {
        std::ostringstream ss;
        ss << inputFile.rdbuf();
        text = ss.str();
    }

    std::string outfile = argv[4];
    std::ofstream file(outfile.c_str(), std::ofstream::binary);

    if (operation == "sign") {
        file << s.sign(text);
    } else if (operation == "decrypt") {
        file << s.decrypt(text);
    } else {
        std::cerr << usageStr << std::endl;
        return -1;
    }

    return 0;
}
