#include "keymaster_proxy_client.h"

#include <yandex_io/libs/keymaster_proxy_client/protos/keymaster_proxy_client.pb.h>

#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/logging/logging.h>

using namespace quasar;
using namespace quasar::keymaster_proxy_client;
using namespace quasar::keymaster_proxy_client::proto;

KeymasterProxyClient::KeymasterProxyClient(std::string signerPath)
    : signerPath_(signerPath)
{
}

std::string KeymasterProxyClient::sign(const std::string& text) {
    YIO_LOG_DEBUG("text.length=" << text.length());
    const Request payload = packSignRequest(text);
    TString serializedPayload;
    Y_PROTOBUF_SUPPRESS_NODISCARD payload.SerializeToString(&serializedPayload);
    YIO_LOG_DEBUG("serializedPayload.length=" << serializedPayload.length());

    return queryKeymaster(serializedPayload);
}

std::string KeymasterProxyClient::decrypt(const std::string& ciphertext) {
    YIO_LOG_DEBUG("ciphertext.length=" << ciphertext.length());
    const Request payload = packDecryptRequest(ciphertext);
    TString serializedPayload;
    Y_PROTOBUF_SUPPRESS_NODISCARD payload.SerializeToString(&serializedPayload);
    YIO_LOG_DEBUG("serializedPayload.length=" << serializedPayload.length());

    return queryKeymaster(serializedPayload);
}

std::string KeymasterProxyClient::exportKey() {
    YIO_LOG_DEBUG("exportKey request");
    const Request payload = packExportKeyRequest();
    TString serializedPayload;
    Y_PROTOBUF_SUPPRESS_NODISCARD payload.SerializeToString(&serializedPayload);
    YIO_LOG_DEBUG("serializedPayload.length=" << serializedPayload.length());
    const auto rawKey = queryKeymaster(serializedPayload);
    std::stringstream key;
    key << "-----BEGIN PUBLIC KEY-----\n"
        << base64Encode(rawKey.c_str(), rawKey.size()) << "\n"
        << "-----END PUBLIC KEY-----";
    return key.str();
}

std::string KeymasterProxyClient::upgradeKey() {
    YIO_LOG_DEBUG("upgradeKey request");
    const Request payload = packUpgradeKeyRequest();
    TString serializedPayload;
    Y_PROTOBUF_SUPPRESS_NODISCARD payload.SerializeToString(&serializedPayload);
    YIO_LOG_DEBUG("serializedPayload.length=" << serializedPayload.length());
    const auto rawKey = queryKeymaster(serializedPayload);
    std::stringstream key;
    key << "-----BEGIN PUBLIC KEY-----\n"
        << base64Encode(rawKey.c_str(), rawKey.size()) << "\n"
        << "-----END PUBLIC KEY-----";
    return key.str();
}

std::string KeymasterProxyClient::queryKeymaster(const std::string& payload) {
    YIO_LOG_DEBUG("payload.length=" << payload.length());
    const std::vector<char> requestData = msgPacker_.pack(payload);
    UnixSocketTransport transport(signerPath_);
    transport.connect();
    YIO_LOG_DEBUG("request.length=" << requestData.size())
    transport.send(requestData);

    const std::string responseData = msgPacker_.unpack(transport);
    transport.close();

    Response response;
    Y_PROTOBUF_SUPPRESS_NODISCARD response.ParseFromString(TString(responseData));
    return unpackResponse(response);
}
