#pragma once

#include "message_packer.h"
#include "payload_packer.h"
#include "unix_socket_transport.h"

#include <mutex>
#include <string>

namespace quasar::keymaster_proxy_client {
    class KeymasterProxyClient {
    public:
        explicit KeymasterProxyClient(std::string signerPath);
        std::string sign(const std::string& text);
        std::string decrypt(const std::string& ciphertext);
        std::string exportKey();
        std::string upgradeKey();

    private:
        std::string queryKeymaster(const std::string& payload);

        MessagePacker msgPacker_;
        std::string signerPath_;
    };
} // namespace quasar::keymaster_proxy_client
