#pragma once

#include "unix_socket_transport.h"

#include <string>
#include <vector>

#include <sys/types.h>

namespace quasar {
    namespace keymaster_proxy_client {
        class MessagePacker {
        public:
            /**
             * Packs serialized protobuf payload into message for keymaster service
             */
            std::vector<char> pack(const std::string& msg) const;

            /**
             * Extracts serialized protobuf payload from keymaster response
             */
            std::string unpack(SignerTransportBase& transport) const;

        private:
            static constexpr uint32_t MAGIC = 0x42fa851f;
            static constexpr uint32_t MAX_SIZE = 1024 * 1024;
        };

    } // namespace keymaster_proxy_client
} // namespace quasar
