#include "payload_packer.h"

#include <yandex_io/libs/base/utils.h>

using namespace quasar::keymaster_proxy_client::proto;

Request quasar::keymaster_proxy_client::packSignRequest(const std::string& text) {
    Request result;
    result.mutable_sign_request()->set_payload(TString(text));
    return result;
}

Request quasar::keymaster_proxy_client::packDecryptRequest(const std::string& ciphertext) {
    Request result;
    result.mutable_decrypt_request()->set_payload(TString(ciphertext));
    return result;
}

Request quasar::keymaster_proxy_client::packExportKeyRequest() {
    Request result;
    result.mutable_export_key_request();
    return result;
}

Request quasar::keymaster_proxy_client::packUpgradeKeyRequest() {
    Request result;
    result.mutable_upgrade_key_request();
    return result;
}

std::string quasar::keymaster_proxy_client::unpackResponse(const Response& response) {
    if (response.has_sign_response()) {
        return response.sign_response().payload();
    } else if (response.has_decrypt_response()) {
        return response.decrypt_response().payload();
    } else if (response.has_export_key_response()) {
        return response.export_key_response().payload();
    } else if (response.has_upgrade_key_response()) {
        return response.upgrade_key_response().payload();
    } else if (response.has_error_response()) {
        throw std::runtime_error("Keymaster error: " + errorCodeToString(response.error_response().code()) + ". Text: " + response.error_response().text());
    } else {
        throw std::runtime_error("Unknown response type");
    }
}

std::string quasar::keymaster_proxy_client::errorCodeToString(ErrorResponse_ErrorCode code) {
    switch (code) {
        case ErrorResponse_ErrorCode_UNKNOWN_PROTOCOL:
            return "UNKNOWN_PROTOCOL";
        case ErrorResponse_ErrorCode_UNKNOWN_REQUEST:
            return "UNKNOWN_REQUEST";
        case ErrorResponse_ErrorCode_INVALID_REQUEST:
            return "INVALID_REQUEST";
        case ErrorResponse_ErrorCode_NOT_IMPLEMENTED_REQUEST:
            return "NOT_IMPLEMENTED_REQUEST";
        case ErrorResponse_ErrorCode_KEYMASTER_ERROR:
            return "KEYMASTER_ERROR";
        default:
            return "unknown error: " + std::to_string(code);
    }
}
