#pragma once

#include <yandex_io/libs/keymaster_proxy_client/protos/keymaster_proxy_client.pb.h>

#include <string>

namespace quasar {
    namespace keymaster_proxy_client {
        /**
         * @brief Packs raw text to protobuf sign message
         */
        keymaster_proxy_client::proto::Request packSignRequest(const std::string& text);

        /**
         * @brief Packs raw text to protobuf decrypt message
         */
        keymaster_proxy_client::proto::Request packDecryptRequest(const std::string& ciphertext);

        /**
         * @brief Packs raw text to protobuf "export key" message
         */
        keymaster_proxy_client::proto::Request packExportKeyRequest();

        /**
         * @brief Creates protobuf "upgrade key" message
         */
        keymaster_proxy_client::proto::Request packUpgradeKeyRequest();

        /**
         * @brief Extract raw message from protobuf response
         */
        std::string unpackResponse(const keymaster_proxy_client::proto::Response& response);

        std::string errorCodeToString(keymaster_proxy_client::proto::ErrorResponse_ErrorCode code);

    } // namespace keymaster_proxy_client
} // namespace quasar
