#pragma once

#include "signer_transport_base.h"

#include <mutex>
#include <string>
#include <vector>

namespace quasar {
    namespace keymaster_proxy_client {
        class UnixSocketTransport: public SignerTransportBase {
        public:
            explicit UnixSocketTransport(std::string socketPath);
            ~UnixSocketTransport();

            void connect() override;
            void close() override;
            void send(const std::vector<char>& data) override;
            std::vector<char> receive(int size) override;

        private:
            static constexpr std::chrono::duration CONNECT_TIMEOUT = std::chrono::seconds(3);
            static constexpr std::chrono::duration WAIT_BETWEEN_CONNECT_RETRIES = std::chrono::milliseconds(500);
            static constexpr std::chrono::duration READ_TIMEOUT = std::chrono::seconds(3);
            static constexpr std::chrono::duration WRITE_TIMEOUT = std::chrono::seconds(3);

            const std::string socketPath_;
            int sock_ = -1;
        };

    } // namespace keymaster_proxy_client
} // namespace quasar
