#pragma once

#include <map>
#include <mutex>
#include <optional>
#include <string>

namespace lmdb {
    class env;
} // namespace lmdb

class KVDatabase {
public:
    KVDatabase(const std::string& path);
    ~KVDatabase();

    void store(const std::string& db, const std::string& key, const std::string& value);
    std::optional<std::string> load(const std::string& db, const std::string& key);
    void erase(const std::string& db, const std::string& key);

    std::map<std::string, std::string> loadAll(const std::string& db);
    void eraseAll(const std::string& db);

private:
    std::mutex mutex_;
    std::unique_ptr<lmdb::env> env_;
};
