#include "logging.h"

namespace quasar::Logging {

    Logger::Logger()
        : logger_(spdlog::default_logger())
    {
    }

    Logger::operator bool() const {
        return bool(logger_);
    }

    bool Logger::shouldLog(spdlog::level::level_enum level) const {
        return logger_->should_log(level);
    }

    void Logger::log(spdlog::source_loc loc, spdlog::level::level_enum level, const std::string& msg) {
        logger_->log(loc, level, msg);
    }

} // namespace quasar::Logging
